/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.compat.jei.category;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.zurrtum.create.AllAssemblyRecipeNames;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllFluids;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllRecipeTypes;
import com.zurrtum.create.client.compat.jei.CreateCategory;
import com.zurrtum.create.client.compat.jei.JeiClientPlugin;
import com.zurrtum.create.client.compat.jei.renderer.IconRenderer;
import com.zurrtum.create.client.compat.jei.widget.JunkChanceTooltip;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.foundation.gui.render.DeployerRenderState;
import com.zurrtum.create.client.foundation.gui.render.PressRenderState;
import com.zurrtum.create.client.foundation.gui.render.SpoutRenderState;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.fluids.potion.PotionFluidHandler;
import com.zurrtum.create.content.fluids.transfer.FillingRecipe;
import com.zurrtum.create.content.kinetics.deployer.DeployerApplicationRecipe;
import com.zurrtum.create.content.kinetics.press.PressingRecipe;
import com.zurrtum.create.content.processing.recipe.ProcessingOutput;
import com.zurrtum.create.content.processing.sequenced.SequencedAssemblyRecipe;
import com.zurrtum.create.infrastructure.component.BottleType;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import mezz.jei.api.fabric.constants.FabricTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotRichTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.types.IRecipeType;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_10289;
import net.minecraft.class_11256;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1844;
import net.minecraft.class_1860;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3956;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_6903;
import net.minecraft.class_7923;
import net.minecraft.class_8786;
import net.minecraft.class_9323;
import net.minecraft.class_9326;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fStack;
import org.joml.Matrix3x2fc;

@Environment(value=EnvType.CLIENT)
public class SequencedAssemblyCategory
extends CreateCategory<class_8786<SequencedAssemblyRecipe>> {
    public static String[] ROMANS = new String[]{"I", "II", "III", "IV", "V", "VI", "-"};
    public static Map<class_3956<?>, SequencedRenderer<?>> RENDER = new IdentityHashMap();

    public static <T extends class_1860<?>> SequencedRenderer<T> getRenderer(T recipe) {
        return RENDER.getOrDefault(recipe.method_17716(), SequencedRenderer.DEFAULT);
    }

    public static <T extends class_1860<?>> void registerRenderer(class_3956<T> type, SequencedRenderer<T> draw) {
        RENDER.put(type, draw);
    }

    public static List<class_8786<SequencedAssemblyRecipe>> getRecipes(class_10289 preparedRecipes) {
        return preparedRecipes.method_64698(AllRecipeTypes.SEQUENCED_ASSEMBLY).stream().toList();
    }

    @NotNull
    public IRecipeType<class_8786<SequencedAssemblyRecipe>> getRecipeType() {
        return JeiClientPlugin.SEQUENCED_ASSEMBLY;
    }

    @NotNull
    public class_2561 getTitle() {
        return CreateLang.translateDirect("recipe.sequenced_assembly", new Object[0]);
    }

    public IDrawable getIcon() {
        return new IconRenderer(AllItems.PRECISION_MECHANISM);
    }

    public int getHeight() {
        return 115;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, class_8786<SequencedAssemblyRecipe> entry, IFocusGroup focuses) {
        SequencedAssemblyRecipe recipe = (SequencedAssemblyRecipe)entry.comp_1933();
        ProcessingOutput chanceOutput = recipe.result();
        boolean randomOutput = chanceOutput.chance() != 1.0f;
        int xOffset = randomOutput ? -7 : 0;
        builder.addInputSlot(xOffset + 22, 91).setBackground((IDrawable)SLOT, -1, -1).add(recipe.ingredient());
        SequencedAssemblyCategory.addChanceSlot(builder, xOffset + 127, 91, chanceOutput);
        if (randomOutput) {
            SequencedAssemblyCategory.addJunkSlot(builder, xOffset + 146, 91).addRichTooltipCallback((IRecipeSlotRichTooltipCallback)new JunkChanceTooltip(1.0f - chanceOutput.chance()));
        }
        List<class_1860<?>> recipes = recipe.sequence();
        int size = recipes.size() / recipe.loops();
        int left = 94 - 14 * size;
        for (int i = 0; i < size; ++i) {
            SequencedAssemblyCategory.addSlot(builder, left + i * 28, recipes.get(i), i);
        }
    }

    private static <T extends class_1860<?>> void addSlot(IRecipeLayoutBuilder builder, int x, T sequence, int i) {
        SequencedRenderer<T> renderer = SequencedAssemblyCategory.getRenderer(sequence);
        IRecipeSlotBuilder slot = renderer.addSlot(builder, x, 15, sequence);
        if (slot != null) {
            slot.addRichTooltipCallback(new SequenceTooltip<T>(renderer, sequence, i)).setSlotName(String.valueOf(i));
        }
    }

    public void draw(class_8786<SequencedAssemblyRecipe> entry, IRecipeSlotsView recipeSlotsView, class_332 graphics, double mouseX, double mouseY) {
        SequencedAssemblyRecipe recipe = (SequencedAssemblyRecipe)entry.comp_1933();
        ProcessingOutput chanceOutput = recipe.result();
        boolean randomOutput = chanceOutput.chance() != 1.0f;
        int xOffset = randomOutput ? -7 : 0;
        List<class_1860<?>> recipes = recipe.sequence();
        int size = recipes.size() / recipe.loops();
        class_327 textRenderer = graphics.field_44656.field_1772;
        int left = 94 - 14 * size;
        for (int i = 0; i < size; ++i) {
            int x = left + i * 28;
            String text = ROMANS[Math.min(i, ROMANS.length)];
            Optional slot = recipeSlotsView.findSlotByName(String.valueOf(i));
            if (slot.isPresent()) {
                AllGuiTextures.JEI_SLOT.render(graphics, x - 1, 14);
            }
            graphics.method_51433(textRenderer, text, x + 8 - textRenderer.method_1727(text) / 2, 2, -7829368, false);
            SequencedAssemblyCategory.getRenderer(recipes.get(i)).render(graphics, i, x, 15, slot);
        }
        AllGuiTextures.JEI_LONG_ARROW.render(graphics, xOffset + 47, 94);
        if (recipe.loops() > 1) {
            AllIcons.I_SEQ_REPEAT.render(graphics, xOffset + 60, 99);
            class_5250 repeat = class_2561.method_43470((String)("x" + recipe.loops()));
            graphics.method_51439(textRenderer, (class_2561)repeat, xOffset + 76, 104, -7829368, false);
        }
    }

    public void getTooltip(ITooltipBuilder tooltip, class_8786<SequencedAssemblyRecipe> entry, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        SequencedAssemblyRecipe recipe = (SequencedAssemblyRecipe)entry.comp_1933();
        if (recipe.loops() > 1 && mouseX >= 43.0 && mouseX < 108.0 && mouseY >= 92.0 && mouseY < 116.0) {
            tooltip.add((class_5348)CreateLang.translateDirect("recipe.assembly.repeat", recipe.loops()));
            return;
        }
        if (mouseY < 5.0 || mouseY > 84.0) {
            return;
        }
        List<class_1860<?>> recipes = recipe.sequence();
        int size = recipes.size() / recipe.loops();
        int left = 88 - 14 * size;
        for (int i = 0; i < size; ++i) {
            int x = left + i * 28;
            if (!((double)x <= mouseX) || !((double)(x + 28) > mouseX)) continue;
            SequencedAssemblyCategory.onRichTooltip(tooltip, recipes.get(i), recipeSlotsView, i);
            break;
        }
    }

    private static <T extends class_1860<?>> void onRichTooltip(ITooltipBuilder tooltip, T recipe, IRecipeSlotsView recipeSlotsView, int i) {
        tooltip.add((class_5348)SequenceTooltip.getStep(i));
        tooltip.add((class_5348)SequenceTooltip.getSequenceName(SequencedAssemblyCategory.getRenderer(recipe), recipe, recipeSlotsView.findSlotByName(String.valueOf(i))));
    }

    static {
        SequencedAssemblyCategory.registerRenderer(AllRecipeTypes.PRESSING, new PressingRenderer());
        SequencedAssemblyCategory.registerRenderer(AllRecipeTypes.DEPLOYING, new DeployingRenderer());
        SequencedAssemblyCategory.registerRenderer(AllRecipeTypes.FILLING, new FillingRenderer());
    }

    @Environment(value=EnvType.CLIENT)
    public static class SequencedRenderer<T extends class_1860<?>> {
        public static final SequencedRenderer<class_1860<?>> DEFAULT = new SequencedRenderer();
        private static final Map<class_1860<?>, class_2561> NAMES = new WeakHashMap();

        public void render(class_332 graphics, int i, int x, int y, Optional<IRecipeSlotView> slot) {
        }

        public class_2561 getSequenceName(T recipe, Optional<IRecipeSlotView> slot) {
            class_2561 name = NAMES.get(recipe);
            if (name != null) {
                return name;
            }
            class_2960 id = class_7923.field_41188.method_10221((Object)recipe.method_17716());
            if (id == null) {
                name = class_5244.field_39003;
            } else {
                class_6903 ops = class_310.method_1551().field_1687.method_30349().method_57093((DynamicOps)JsonOps.INSTANCE);
                name = class_1860.field_47319.encodeStart((DynamicOps)ops, recipe).result().map(json -> AllAssemblyRecipeNames.get((DynamicOps<JsonElement>)ops, json)).orElse(class_5244.field_39003);
            }
            NAMES.put((class_1860<?>)recipe, name);
            return name;
        }

        public IRecipeSlotBuilder addSlot(IRecipeLayoutBuilder builder, int x, int y, T recipe) {
            return CreateCategory.addJunkSlot(builder, x, y);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public record SequenceTooltip<T extends class_1860<?>>(SequencedRenderer<T> renderer, T recipe, int i) implements IRecipeSlotRichTooltipCallback
    {
        public static class_2561 getStep(int i) {
            return CreateLang.translateDirect("recipe.assembly.step", i + 1);
        }

        public static <T extends class_1860<?>> class_2561 getSequenceName(SequencedRenderer<T> renderer, T recipe, Optional<IRecipeSlotView> slot) {
            return renderer.getSequenceName(recipe, slot).method_27661().method_27692(class_124.field_1077);
        }

        public void onRichTooltip(IRecipeSlotView slot, ITooltipBuilder tooltip) {
            List lines = tooltip.getLines();
            if (!lines.isEmpty()) {
                lines.removeFirst();
            }
            lines.addAll(0, List.of(Either.left((Object)SequenceTooltip.getStep(this.i)), Either.left((Object)SequenceTooltip.getSequenceName(this.renderer, this.recipe, Optional.of(slot)))));
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class PressingRenderer
    extends SequencedRenderer<PressingRecipe> {
        @Override
        public void render(class_332 graphics, int i, int x, int y, Optional<IRecipeSlotView> slot) {
            float scale = 0.6333333f;
            Matrix3x2fStack matrices = graphics.method_51448();
            matrices.pushMatrix();
            matrices.translate((float)x, (float)y);
            matrices.scale(scale, scale);
            matrices.translate((float)(-x), (float)(-y));
            graphics.field_59826.method_70922((class_11256)new PressRenderState(i, new Matrix3x2f((Matrix3x2fc)matrices), x - 3, y + 18, i));
            matrices.popMatrix();
        }

        @Override
        public IRecipeSlotBuilder addSlot(IRecipeLayoutBuilder builder, int x, int y, PressingRecipe recipe) {
            return null;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class DeployingRenderer
    extends SequencedRenderer<DeployerApplicationRecipe> {
        @Override
        public void render(class_332 graphics, int i, int x, int y, Optional<IRecipeSlotView> slot) {
            float scale = 0.75641024f;
            Matrix3x2fStack matrices = graphics.method_51448();
            matrices.pushMatrix();
            matrices.translate((float)x, (float)y);
            matrices.scale(scale, scale);
            matrices.translate((float)(-x), (float)(-y));
            graphics.field_59826.method_70922((class_11256)new DeployerRenderState(i, new Matrix3x2f((Matrix3x2fc)matrices), x - 3, y + 18, i));
            matrices.popMatrix();
        }

        @Override
        public class_2561 getSequenceName(DeployerApplicationRecipe recipe, Optional<IRecipeSlotView> slot) {
            class_2561 name = slot.flatMap(IRecipeSlotView::getDisplayedItemStack).map(class_1799::method_7964).orElse(class_5244.field_39003);
            return class_2561.method_43469((String)"create.recipe.assembly.deploying_item", (Object[])new Object[]{name});
        }

        @Override
        public IRecipeSlotBuilder addSlot(IRecipeLayoutBuilder builder, int x, int y, DeployerApplicationRecipe recipe) {
            return (IRecipeSlotBuilder)builder.addInputSlot(x, y).setBackground((IDrawable)CreateCategory.EMPTY, 0, 0).add(recipe.ingredient());
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class FillingRenderer
    extends SequencedRenderer<FillingRecipe> {
        @Override
        public void render(class_332 graphics, int i, int x, int y, Optional<IRecipeSlotView> slot) {
            slot.flatMap(s -> s.getDisplayedIngredient((IIngredientType)FabricTypes.FLUID_STACK)).ifPresent(ingredient -> {
                float scale = 0.76086956f;
                Matrix3x2fStack matrices = graphics.method_51448();
                matrices.pushMatrix();
                matrices.translate((float)x, (float)y);
                matrices.scale(scale, scale);
                matrices.translate((float)(-x), (float)(-y));
                FluidVariant fluidVariant = ingredient.getFluidVariant();
                class_3611 fluid = fluidVariant.getFluid();
                class_9326 components = fluidVariant.getComponents();
                graphics.field_59826.method_70922((class_11256)new SpoutRenderState(i, new Matrix3x2f((Matrix3x2fc)matrices), fluid, components, x - 2, y + 24, i));
                matrices.popMatrix();
            });
        }

        @Override
        public class_2561 getSequenceName(FillingRecipe recipe, Optional<IRecipeSlotView> slot) {
            class_2561 name = slot.flatMap(s -> s.getDisplayedIngredient((IIngredientType)FabricTypes.FLUID_STACK)).map(ingredient -> {
                FluidVariant fluidVariant = ingredient.getFluidVariant();
                class_3611 fluid = fluidVariant.getFluid();
                if (fluid == AllFluids.POTION) {
                    class_9323 components = fluidVariant.getComponentMap();
                    class_1844 contents = (class_1844)components.method_58695(class_9334.field_49651, (Object)class_1844.field_49274);
                    BottleType bottleType = (BottleType)((Object)((Object)components.method_58695(AllDataComponents.POTION_FLUID_BOTTLE_TYPE, (Object)BottleType.REGULAR)));
                    class_1792 itemFromBottleType = PotionFluidHandler.itemFromBottleType(bottleType);
                    return contents.method_64195(itemFromBottleType.method_8389().method_7876() + ".effect.");
                }
                class_2248 block = fluid.method_15785().method_15759().method_26204();
                if (fluid != class_3612.field_15906 && block == class_2246.field_10124) {
                    return class_2561.method_43471((String)class_156.method_646((String)"block", (class_2960)class_7923.field_41173.method_10221((Object)fluid)));
                }
                return block.method_9518();
            }).orElse(class_5244.field_39003);
            return class_2561.method_43469((String)"create.recipe.assembly.spout_filling_fluid", (Object[])new Object[]{name});
        }

        @Override
        public IRecipeSlotBuilder addSlot(IRecipeLayoutBuilder builder, int x, int y, FillingRecipe recipe) {
            return CreateCategory.addFluidSlot(builder, x, y, recipe.fluidIngredient());
        }
    }
}

